<?php
/*
Template Name: Change  Account Password
*/

global $current_user, $taxonomy_profile_url, $taxonomy_agency_url;
get_currentuserinfo();
if (!in_array(get_option("escortid".$current_user->ID), array($taxonomy_agency_url, $taxonomy_profile_url, 'member'))) { wp_redirect(get_bloginfo("url")); exit; }

$err = ""; $ok = "";
if (isset($_POST['action']) && $_POST['action'] == 'change' && is_user_logged_in()) {
    $pass = $_POST['pass'];
	if ($pass) {
		if (strlen($pass) < 6 || strlen($pass) > 50) {
			$err .= _d('Your password must be between 6 and 50 characters',464)."<br />";
			unset($pass);
		} else {
			if ( false !== strpos( stripslashes($pass), "\\" ) ) {
				$err .= _d('Passwords may not contain the character "\"',785)."<br />";
			} else {
				wp_update_user( array ('ID' => $current_user->ID, 'user_pass' => $pass) ) ;
				$ok = _d('Your new password is',465).": $pass";
				unset($pass);
			}
		}
	} else {
		$err .= _d('The password field is empty',466)."<br />";
	}
}

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox registerform">
        	<h3><?php _de('Change Account Password',467); ?></h3>
			<?php if ($ok) { echo "<div class=\"ok rad3\">$ok</div>"; } ?>
			<?php if ($err) { echo "<div class=\"err rad3\">$err</div>"; } ?>
			<form action="<?php echo get_permalink(get_option('change_password_page_id')); ?>" method="post" class="form-styling">
				<input type="hidden" name="action" value="change" />
				<div class="clear20"></div>
				<div class="form-label">
			    	<label for="pass"><?php _de('New Password',468); ?></label>
			    	<small><?php _de('Must be between 6 and 50 characters',412); ?></small>
			    </div>
			    <div class="form-input">
			    	<input type="password" name="pass" id="pass" class="input longinput" value="" autocomplete="off" />
			    </div> <!-- password --> <div class="form-separator"></div>

			    <div class="clear20"></div>
			    <div class="center"><input type="submit" name="submit" value="<?php _de('Update Password',469); ?>" class="bluebutton rad3" /></div> <!--center-->
			</form>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
        <div class="clear"></div>
    </div> <!-- BODY -->
	</div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>