<?php
/*
Template Name: Register Independent Verified Status
*/

global $current_user, $taxonomy_profile_url;
get_currentuserinfo();
if (get_option("escortid".$current_user->ID) != $taxonomy_profile_url) { wp_redirect(get_bloginfo("url")); exit; }
$current_user_post_id = get_option("escortpostid".$current_user->ID);
$verified_photo = get_post_meta($current_user_post_id, "verified_status", true);
get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox girlsingle upload_verified_photo">
        	<h3><?php _de('Verify Account',532); ?></h3>
			<script type="text/javascript">
			jQuery(document).ready(function($) {
			    $('#file_upload').uploadifive({
					'auto'           : true,
					'buttonClass'    : 'bluebutton rad5',
					'buttonText'     : '<?php _de('Upload image',1070) ?>',
					'fileSizeLimit'  : '5MB',
			        'fileType'       : 'image/*',
			        'formData'       : { 'folder' : '<?php echo get_post_meta($current_user_post_id, "secret", true); ?>' },
					'multi'          : false,
					'queueID'        : 'upload-queue',
					'queueSizeLimit' : 1,
					'removeCompleted': true,
					'simUploadLimit' : 1,
					'uploadLimit'    : 100,
					'uploadScript'   : '<?php bloginfo('template_url'); ?>/register-independent-verified-status-process.php',
					'onQueueComplete': function(data) {
						$('#status-message').html('<?php _de('Your image has been uploaded',173); ?>.<br /><'+'a href="<?php echo get_permalink(get_the_ID()); ?>"><?php _de('Refresh the page to see it',1071); ?><'+'/a><br /><br /><?php _de('Refreshing the page automatically in 2 seconds',1095); ?>');
						setTimeout(location.reload(), 0);
					}
				});

				//delete an image from the account
				$('.thumbs .button-delete').on('click', function(){
					$('.profile-img-thumb img').fadeTo('slow', 0.3).css('z-index', '0');
					$('.profile-img-thumb .edit-buttons').html('<div class="preloader r"><'+'/div>');
					loader('.profile-img-thumb .edit-buttons .preloader');
					$.ajax({
						type: "GET",
						url: "<?php bloginfo('template_url'); ?>/ajax/delete-verified-status-image.php",
						data: "id=" + <?=$verified_photo?>,
						success: function(data){
							$('.profile-img-thumb .edit-buttons').html('<div class="image_msg_girl_single">'+data+'<'+'/div>');
							setTimeout(function () {
								$('.profile-img-thumb .edit-buttons').slideUp();
							    $('.profile-img-thumb a').animate({
							    	width: 0},
							    	500, function() {
							    	$(this).hide();
							    });
							}, 2000);
						}
					});
				});
			});
			</script>
			<div class="upload_photos_form">
				<div id="status-message">
			    	<div class="upload_photos_button r">
						<input id="file_upload" name="file_upload" type="file" />
			    	</div>
				<?php _de('Increase the credibility of your account by submitting a verification photo.',1085); ?><br />
				<?php _de('Please upload a photo of yourself holding a paper in your hands with the name of our website.',1086); ?><br />
				<?php _de('All photos are private and will not be published!',493); ?><br />
				<?php _de('You can only upload 1 photo.',494); ?>
		        </div>
		        <div class="clear"></div>
				<div id="upload-queue"></div><div class="clear20"></div>
		        <div class="image_msg l"></div><div class="clear"></div>
				<?php
				if($verified_photo) {
					$verified_photo_url = wp_get_attachment_image_src($verified_photo, 'full');
					$verified_photo_th_url = wp_get_attachment_image_src($verified_photo, 'listings-thumb');
					if($verified_photo_th_url[3] != "1") {
						require_once( ABSPATH . 'wp-admin/includes/image.php' );
						$attach_data = wp_generate_attachment_metadata($verified_photo, get_attached_file($verified_photo));
						wp_update_attachment_metadata($verified_photo, $attach_data);
						$verified_photo_th_url = wp_get_attachment_image_src($verified_photo, 'listings-thumb');
					}
					if($verified_photo_url) {
				?>
					<h4><?php _de('Images you uploaded for verification:',495); ?></h4>
					<div class="clear10"></div>
					<div class="thumbs col30 m50">
						<span class="profile-img-thumb l">
							<span class="edit-buttons"><span class="icon button-delete icon-cancel"></span></span>
							<a href="<?php echo $verified_photo_url[0]; ?>" rel="profile-photo">
								<img src="<?php echo $verified_photo_th_url[0]; ?>" class="rad3" />
							</a>
						</span>
					</div>
				<?php
					} // if($verified_photo_url)
				}
				?>
			</div> <!-- UPLOAD PHOTOS FORM-->
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
        <div class="clear"></div>
    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>