<?php
/*
Template Name: Upload/Edit Agency Logo
*/

global $current_user, $taxonomy_agency_url, $taxonomy_agency_name;
get_currentuserinfo();
if (get_option("escortid".$current_user->ID) != $taxonomy_agency_url) { wp_redirect(get_bloginfo("url")); exit; }

get_header(); ?>

		<div class="contentwrapper">
		<div class="body">
        	<div class="bodybox upload_photos_page">
            	<h3><?php _de('Upload/Edit %s Logo',521,$taxonomy_agency_name); ?></h3>

				<script type="text/javascript">
				jQuery(document).ready(function($) {
				    $('#file_upload').uploadifive({
						'auto'           : true,
						'buttonClass'    : 'bluebutton rad5',
						'buttonText'     : '<?php _de('Upload logo',1069) ?>',
						'fileSizeLimit'  : '5MB',
				        'fileType'       : 'image/*',
				        'formData'       : { 'folder' : '<?php echo get_post_meta(get_option("agencypostid".$current_user->ID), "secret", true); ?>' },
						'multi'          : false,
						'queueID'        : 'upload-queue',
						'queueSizeLimit' : 1,
						'removeCompleted': true,
						'simUploadLimit' : 1,
						'uploadLimit'    : 100,
						'uploadScript'   : '<?php bloginfo('template_url'); ?>/register-agency-upload-logo-process.php',
						'onQueueComplete': function(data) {
							$('#status-message').html('<?php _de('Your image has been uploaded',173); ?>.<br /><'+'a href="<?php echo get_permalink(get_the_ID()); ?>"><?php _de('Refresh the page to see it',1071); ?><'+'/a>');
							setTimeout(location.reload(), 0);
						}
					});

					//delete an image from the account
					$('.upload_photos_page .girl span i').on('click', function(){
						$(this).hide();
						var imgid = $(this).text();
						$("#img"+imgid).fadeOut("slow");
						$.ajax({
							type: "GET",
							url: "<?php bloginfo('template_url'); ?>/ajax/delete-agency-logo.php",
							data: "id=" + imgid,
							success: function(data){
								$('.image_msg').html(data).fadeIn("slow").delay(1000).fadeOut("slow");
							}
						});
					});
				});
				</script>
				<div class="upload_photos_form">
			    	<div class="upload_photos_button l">
						<input id="file_upload" name="file_upload" type="file" />
			    	</div>
					<div id="status-message" class="r"><?php _de('Click the button and select your %s logo.',522,$taxonomy_agency_name); ?><br /><?php _de('You can only upload a single image. To change an uploaded logo you have to delete the current one and upload another one.',523); ?></div>
			        <div class="clear"></div>
					<div id="upload-queue"></div>
					<div class="clear20"></div>
			        <div class="l">
						<h4><?php _de('The %s logo you will be using',524,$taxonomy_agency_name); ?>:</h4>
						<small><?php _de('refresh the page after you upload a logo',525); ?></small>
					</div>
			        <div class="image_msg l"></div>
			        <div class="r"><img src="<?php bloginfo("template_url"); ?>/i/icon-no.png" /> <?php _de('Delete image',496); ?></div>
					<div class="clear10"></div>
					<?php
					//check and display the photos uploaded by the user
					global $post;
					$current_user_post = get_option("agencypostid".$current_user->ID);
					$photos = get_children( array('post_parent' => $current_user_post, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID') );
					sort($photos);
					//get the images uploaded
					foreach ($photos as $key => $ag_photo) {
						$ag_photo_th_url = wp_get_attachment_image_src($ag_photo->ID, 'listings-thumb');
						if($ag_photo_th_url[3] != "1") {
							require_once( ABSPATH . 'wp-admin/includes/image.php' );
							$attach_data = wp_generate_attachment_metadata($ag_photo->ID, get_attached_file($ag_photo->ID));
							wp_update_attachment_metadata($ag_photo->ID, $attach_data);
							$ag_photo_th_url = wp_get_attachment_image_src($ag_photo->ID, 'listings-thumb');
						}
						echo '<div class="girl" id="img'.$ag_photo->ID.'"><span class="rad3"><img src="'.$ag_photo_th_url[0].'" class="rad3" alt="" /><i class="rad3">'.$ag_photo->ID.'</i></span><div class="clear"></div></div> <!-- GIRL -->'."\n";
					}
					?>
				</div> <!-- UPLOAD PHOTOS FORM-->
                <div class="clear"></div>
            </div> <!-- BODY BOX -->
            <div class="clear"></div>
        </div> <!-- BODY -->
        </div> <!-- contentwrapper -->

		<?php get_sidebar("left"); ?>
		<?php get_sidebar("right"); ?>
    	<div class="clear"></div>
<?php get_footer(); ?>