jQuery(document).ready(function($) {
	var start_mobile_size = 960;

	if($('body').hasClass('isphone')) { var isphone = true; }

	vcenter = function() {
		$('.vcenter').each(function(index, el) {
			$(this).css('margin-top', ($(this).parent().outerHeight() - $(this).outerHeight()) / 2);
		});
	}
	vcenter();

	if($('.all-header-slider .sliderall .slider').length) {
		var owlcarouselautoplay = false;
		if($('.all-header-slider').data('autoscroll') == "yes") {
			owlcarouselautoplay = true;
		}

		$('.all-header-slider .sliderall .slider').owlCarousel({
			items: 6,
			loop: true,
			nav: true,
			center: false,
			autoplay: owlcarouselautoplay,
			autoplayTimeout: 4000,
			autoplaySpeed: 600,
			margin: 10,
			autoplayHoverPause: true,
			navText: ['<span class="icon-left-open"></span>','<span class="icon-right-open"></span>'],
			stagePadding: 0,
			responsive : {
				0 : {
					items: 2,
				},
				// breakpoint from 500 up
				500 : {
					items: 4,
				},
				// breakpoint from 700 up
				700 : {
					items: 5,
				},
				// breakpoint from 1150 up
				1150 : {
					items: 6,
				}
			}
		});
	} // if($('.all-header-slider .sliderall .slider').length) {

	$('.headerlang').change(function() {
		var lang = $(this).val();
		Cookies.set('sitelang', lang);
		location.reload();
	});

	if($('.country-list li').length) {
		$('.country-list li').each(function(index, el) {
			if($(this).find('ul').length) {
				$(this).prepend('<span class="iconlocation icon-angle-down"></span>')
			} else {
				$(this).prepend('<span class="iconlocation icon-minus"></span>')
			}
		});
		
		$('.country-list li ul').hide();
	}
	$('.country-list .current-cat').parentsUntil('.country-list').show();
	$('.country-list .current-cat > ul').show();
	$('.country-list .current-cat-parent > .icon-angle-down').removeClass("icon-angle-down").addClass("icon-angle-up");
	$('.country-list .current-cat > .icon-angle-down').removeClass("icon-angle-down").addClass("icon-angle-up");

	$('.country-list li .iconlocation').on('click', function(){
		if($(this).hasClass('icon-angle-down')) {
			$(this).parent().find("ul").first().show();
			$(this).removeClass("icon-angle-down").addClass("icon-angle-up");
		} else {
			$(this).parent().find("ul").first().hide();
			$(this).removeClass("icon-angle-up").addClass("icon-angle-down");
		}
	});

	function prepare_responsive() {
		var headerwidth = $(window).width();
		if(isphone || headerwidth <= start_mobile_size) {
			window.isMobile = true;
		} else {
			window.isMobile = false;
		}

		if(isphone || headerwidth <= start_mobile_size) {
			if($('.select2').length) {
				$('select.select2-hidden-accessible').select2('destroy');
			}
		} else {
			if($('.select2').length) {
				$('.select2').select2({
					minimumResultsForSearch: 20
				});
			}
		}

		if(isphone || headerwidth <= start_mobile_size) {
			//responsive images in profile page
			//only show the images if they are in viewport
			if($('.bigimage').length && $('.lockedsection').length) {
				$('.bigimage').addClass('col100').show();
			}
			function show_profile_images() {
				if($('.mobile-ready-img').length) {
					$('.mobile-ready-img').each(function() {
						if(isElementInViewport($(this)) && (!$(this).attr('src') || $(this).attr('src') != $(this).data('responsive-img-url'))) {
							$(this).css('opacity', '0').attr('src', $(this).data('responsive-img-url')).fadeTo('slow', 1);
						}
					});
				}
			}
			show_profile_images();
			$(window).scroll(function(event){
				if(isphone || headerwidth <= start_mobile_size) {
					show_profile_images();
				}
			});


			$('a[rel=profile-photo]').on('click', function(event) {
				event.preventDefault();
			});
			var mobile_text = $('.profile-page-no-photos .for-browsers').data('mobile-text');
			$('.profile-page-no-photos .for-browsers').data('original-text', $('.profile-page-no-photos .for-browsers').html()).find('p').text(mobile_text);

			var mobile_text_v = $('.profile-page-no-videos .for-browsers').data('mobile-text');
			$('.profile-page-no-videos .for-browsers').data('original-text', $('.profile-page-no-videos .for-browsers').html()).find('p').text(mobile_text_v);
		} else {
			if($('.bigimage').length && $('.lockedsection').length) {
				$('.bigimage').removeClass('col100').show();
			}
			if($('.mobile-ready-img').length) {
				$('.mobile-ready-img').each(function() {
					if($(this).attr('src') != $(this).data('original-url')) {
						$(this).attr('src', $(this).data('original-url'));
					}
				});
			};
			$('.profile-page-no-photos .for-browsers').html($('.profile-page-no-photos .for-browsers').data('original-text'));
			$('.profile-page-no-videos .for-browsers').html($('.profile-page-no-videos .for-browsers').data('original-text'));

			//only show pop-up images on click on a big browser
			if ($.isFunction($.fn.fancybox)) {
				$("a[rel=profile-photo]").fancybox({
					scrollOutside: false,
					helpers	: {
						thumbs	: {
							width	: 70,
							height	: 70
						}
					}
				});
			}
		} // responsive images in profile page

		// open video player on video click
		if ($.isFunction($.fn.fancybox)) {
			$("a[rel=profile-video]").fancybox({
				scrollOutside: false,
				helpers	: {
					thumbs	: {
						width	: 70,
						height	: 70
					}
				},
				beforeClose: function() {
					$("video").each(function() {
						$(this).get(0).pause();
					});
				}
			});
		}

		if(isphone || headerwidth <= start_mobile_size) {
			$('.bodybox-homepage').each(function(index, el) {
				$(this).find('.girl').slice(4).hide();
			});

			$('.bodybox-homepage .see-more-button').on('click', function(event) {
				event.preventDefault();
				if($(this).parent().find(".girl:hidden").length > 0) {
					$(this).hide().parent().find(".girl").show().siblings('.see-all-bottom').css('display', 'block');
				} else {
					window.location = $(this).siblings('.see-all-bottom').attr('href');
				}
			});

			//front-page hide all reviews except the first one
			$('.onereviewtext-homepage:visible').slice(3).hide();
		} else {
			$('.bodybox-homepage .girl, .onereviewtext-homepage').show();
		}

		if($('header .header-nav').length) {
			$('header').removeClass('header-mobile1 header-mobile2');
			if($('header .header-nav').offset().top < $('header .subnav-menu-wrapper').offset().top) {
				$('header').addClass('header-mobile1');
				if($('header .header-nav').offset().top < $('header .subnav-menu-wrapper').offset().top) {
					$('header').addClass('header-mobile2');
				}
			}
		}

		if($('.single-profile-page .profile-header').length) {
			$('.single-profile-page .profile-header').removeClass('profile-header-mobile1 profile-header-mobile2');
			if($('.single-profile-page .girlsingle .phone-box').offset().top > $('.single-profile-page .girlsingle .profile-header-name').offset().top) {
				$('.single-profile-page .profile-header').addClass('profile-header-mobile1');
				if($('.single-profile-page .girlsingle .phone-box').offset().top > $('.single-profile-page .girlsingle .profile-header-name-info').offset().top) {
					$('.single-profile-page .profile-header').addClass('profile-header-mobile2');
				}
			}
		}
	} // function prepare_responsive()

	var headerwidth = $(window).width();
	prepare_responsive();
	$(window).resize(function(){
		prepare_responsive();
	});


	$(".sidebar-right .dropdownlinks-dropdown h4").on('click', function(){
		$(this).parent().find('ul').stop().slideToggle('fast');
	});

	//right-sidebar js START
	//escort js
	$(".sidebar-right .buyfeatured").on('click', function(){
		$('.buyfeatured_details').slideDown("fast");
	});
	$(".buyfeatured_details .closebtn_box").on('click', function(){
		$('.buyfeatured_details').slideUp("fast");
	});

	$(".sidebar-right .buypremium").on('click', function(){
		$('.buypremium_details').slideDown("fast");
	});
	$(".buypremium_details .closebtn_box").on('click', function(){
		$('.buypremium_details').slideUp("fast");
	});

	// admin menu js
	$(".manuallyactivatetour").on('click', function(){
		$('.manuallyactivatetour_div').slideDown('fast');
		$('.manuallyactivatevip_div').slideUp('fast');
	});
	$(".manuallyactivatevip").on('click', function(){
		$('.manuallyactivatevip_div').slideDown('fast');
		$('.manuallyactivatetour_div').slideUp('fast');
	});

	// escort menu shown to admin
	$('.upgradebutton').on('click', function(){
		$('.upgradebuttons').slideDown();
		$('.upgradeescortbox').slideUp();
		$(this).parent().siblings('.upgradeescortbox').slideDown('fast');
		$(this).parent().slideUp('fast');
	});
	$('.upgradeescortbox .closebtn_box').on('click', function(){
		if($(this).parent().siblings('.upgradebuttons')) {
			$(this).parent().siblings('.upgradebuttons').slideDown('fast');
		}
		$(this).parent().slideUp('fast');
	});

	//agency js
	$('.addescort').on('click', function(){
		$('.addnewescortform').slideToggle("slow");
		$('.addescort span').toggle();
	});
	$('.agencyeditbuttons a').on('click', function(){
		var className = $(this).attr("class");
		$('.agency_options_dropdowns').slideUp();
		$('.agency_options_'+className).slideDown();
		$('.girlsingle').slideUp();
		$('.select2').select2();
	});
	$('.agency_options_dropdowns .closebtn').on('click', function(){
		$(this).parent().slideUp();
		$('.girlsingle').slideDown();
	});
	//right-sidebar js END

	//animate loader div
	loader=function(l, nohtml){
		if(!nohtml) {
			$(l).html('<div class="loader rad3"><span class="rad3"></span></div>');
		}
		if($(l).find('.loader').is(':visible')){
			$(l).find('.loader span').css('left', '-100%').animate({ 'left': '100%'}, 2000, function(){
				loader(l, "no");
			});
		}
	}

	function isElementInViewport(el) {
	    var docViewTop = $(window).scrollTop();
	    var docViewBottom = docViewTop + $(window).height();

	    var elemTop = $(el).offset().top;
	    var elemBottom = elemTop + $(el).height();
	    //return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
	    return ((elemTop >= docViewTop) && (elemTop <= docViewBottom) || (elemBottom >= docViewTop) && (elemBottom <= docViewBottom));
	}
});

function getCookie(c_name) {
	var i,x,y,ARRcookies=document.cookie.split(";");
	for (i=0; i<ARRcookies.length;i++) {
		x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
		y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
		x=x.replace(/^\s+|\s+$/g,"");
		if (x==c_name) {
			return unescape(y);
		}
	}
}