<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }

?>
<div class="sidebar-right">
<?php
global $payment_options_a, $current_user, $taxonomy_profile_name, $taxonomy_profile_name_plural, $taxonomy_location_url, $taxonomy_profile_url, $taxonomy_agency_url, $taxonomy_agency_name, $gender_a, $settings_theme_genders;
get_currentuserinfo();
if(is_user_logged_in()) {
	$userid = $current_user->ID;
	$userstatus = get_option("escortid".$userid);
} else {
	$userid = "none"; $userstatus = "none";
}

// if classified ad is private and needs to be manually activated by an admin
if(is_single() && get_post_status() == "private" && get_post_type() == "ad" && (get_the_author_meta('ID') == $userid || current_user_can('level_10'))) {
	if(current_user_can('level_10')) { ?>
		<div class="sidebar_expire_notice reddegrade center">
			<?php _de('This ad requires manual activation',1286); ?>
			<div class="clear5"></div>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
				<input type="hidden" name="action" value="activateprivatead" />
				<div class="clear5"></div>
				<input type="submit" name="submit" class="bluebutton rad3" value="<?php _de('Activate ad',1287); ?>" />
				<div class="clear5"></div>
			</form>
		</div>
	<?php
	} // if not an admin then show the owner of the profile a message
} // if profile is private and needs to be manually activated by an admin


// if profile is private and needs to be manually activated by an admin
if(is_single() && get_post_status() == "private" && get_post_meta(get_the_ID(), "notactive", true) == "1" && (get_the_author_meta('ID') == $userid || current_user_can('level_10'))) {
	if(current_user_can('level_10')) { ?>
		<div class="sidebar_expire_notice reddegrade center">
			<?php _de('This profile requires manual activation',845); ?>
			<div class="clear5"></div>
			<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
				<input type="hidden" name="action" value="activateprivateprofile" />
				<div class="clear5"></div>
				<input type="submit" name="submit" class="bluebutton rad3" value="<?php _de('Activate profile',846); ?>" />
				<div class="clear5"></div>
			</form>
		</div>
	<?php
	} else {
		echo '<div class="ok">'._d('This profile is currently set to private.',847).'<br />'._d('This website requires all profiles to be manually activated by an admin.',848).'</div>';
	} // if not an admin then show the owner of the profile a message
} // if profile is private and needs to be manually activated by an admin

// if profile or agency needs payment and is admin
if (is_single() && get_post_meta(get_the_ID(), "needs_payment", true) == "1" && current_user_can('level_10')) { ?>
	<div class="sidebar_expire_notice reddegrade center">
		<?php _de('The owner of this profile has not paid the registration fee yet',967); ?>
		<div class="clear5"></div>
		<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
			<input type="hidden" name="action" value="activateunpaidprofile" />
			<div class="clear20"></div>
			<?=_d('Activate account for a period of',1234)?>:
			<div class="clear5"></div>
			<select name="profileduration" class="activation-duration">
				<option value=""><?php _de('Forever',822); ?></option>
				<?php foreach($payment_options_a as $key => $p) { echo '<option value="'.$key.'">'.$p[0].'</option>'."\n"; } ?>
			</select>
			<div class="clear5"></div>
			<input type="submit" name="submit" class="activation-button bluebutton rad3" value="<?php _de('Activate profile',846); ?>" />
			<div class="clear5"></div>
		</form>
	</div>
	<?php
} // if profile needs payment and is admin


// if agency's profile is private and needs to receive payment first
if($userstatus == $taxonomy_agency_url && get_post_status(get_option("agencypostid".$userid)) == "private" && get_post_meta(get_option("agencypostid".$userid), "needs_payment", true) == "1") {
	$agency_has_not_payed = "yes"; // adding marker to check later if we should show all account links or not
	echo '<div class="sidebar_expire_notice reddegrade center">';
		_de('Your %s profile will not be shown in the site until you pay the registration fee.',961,$taxonomy_agency_name);
		echo '<div class="clear10"></div>';
		echo '<div class="center">'.generate_payment_buttons("6", get_option("agencypostid".$userid))."</div> <!--center-->";
		echo '<div class="clear5"></div>';
		if(get_option("agregprice")) {
			echo format_price('6', "yes");
		}
	echo '</div>';
} // if agency's profile is private and needs to receive payment first
// if profile added by agency is private and agency needs payment
if(is_single() && get_post_status() == "private" && get_the_author_meta('ID') == $userid && $userstatus == $taxonomy_agency_url && get_post_type() == $taxonomy_profile_url && get_post_meta(get_the_ID(), "needs_ag_payment", true) == "1") {
	echo '<div class="sidebar_expire_notice reddegrade center">';
		_de('This %s profile has been set to private. It will be reactivated after you pay your registration fee.',1243,$taxonomy_profile_name);
		echo '<div class="clear10"></div>';
		echo '<div class="center">'.generate_payment_buttons("7", get_option("agencypostid".$userid))."</div> <!--center-->";
		echo '<div class="clear5"></div>';
		if(get_option("agregprice")) {
			echo format_price('7', "yes");
		}
	echo '</div>';
}

// if escort from agency is private and needs payment
if(is_single() && get_post_status() == "private" && get_the_author_meta('ID') == $userid && $userstatus == $taxonomy_agency_url && get_post_type() == $taxonomy_profile_url && get_post_meta(get_the_ID(), "needs_payment", true) == "1") {
	$escort_from_agency_has_not_payed = "yes"; // adding marker to check later if we should show all account links or not
	echo '<div class="sidebar_expire_notice reddegrade center">'._d('This %s profile will not be shown in the site until you pay the registration fee.',965,$taxonomy_profile_name);
	echo '<div class="clear10"></div>';
	echo '<div class="center">'.generate_payment_buttons("7", get_the_ID())."</div>";
	echo '<div class="clear5"></div>';
	if(get_option("agescortregprice")) {
		echo format_price('7', "yes");
	}
	echo '</div>';
} // if escort from agency is private and needs payment

// if independent escort profile is private and needs to receive payment first
if($userstatus == $taxonomy_profile_url && get_post_status(get_option("escortpostid".$userid)) == "private" && get_post_meta(get_option("escortpostid".$userid), "needs_payment", true) == "1") {
	$escort_has_not_payed = "yes"; // adding marker to check later if we should show all account links or not
	echo '<div class="sidebar_expire_notice reddegrade center">'._d('Your %s profile will not be shown in the site until you pay the registration fee.',961,$taxonomy_profile_name);
	echo '<div class="clear10"></div>';
	echo '<div class="center">'.generate_payment_buttons("8", get_option("escortpostid".$userid))."</div> <!--center-->";
	echo '<div class="clear5"></div>';
	if(get_option("indescregprice")) {
		echo format_price('8', "yes");
	}
	echo '</div>';
} // if escort and profile is private and needs to receive payment first


// Buttons to buy premium & featured
if (get_the_author_meta('ID') == $userid && get_post_type() == $taxonomy_profile_url) { ?>
	<?php if (get_option("premiumprice") && get_post_meta(get_the_ID(), "premium", true) != "1" && get_post_type() == $taxonomy_profile_url && is_single() && get_option("paymentgateway")) { ?>
	<div class="clear5"></div>
	<div class="orangebutton buypremium"><?php _de('Premium Position',634); ?><span class="rad3 greendegrade"><?php echo format_price('1') ?></span></div>
    <div class="buypremium_details blueishdegrade">
	    <?php closebtn('2') ?>
	    <?php
    	_de('Premium %s will always be shown first and before any normal %s, in all the pages of the site.',635,array($taxonomy_profile_name_plural,$taxonomy_profile_name_plural));
		if(get_option("premiumduration")) {
			echo "<br />"._d('Your premium status will be active for',886).' <strong>'.$payment_options_a[get_option("premiumduration")][0].'</strong> ';
			if(get_option("premiumsubscription") == "yes") {
				echo _d('and you\'ll be billed again after that period expires',885).".";
			}
		}
		?>
	    <div class="clear5"></div>
		<div class="center"><?php echo generate_payment_buttons('1',get_the_ID()); ?></div> <!--center-->
		<div class="center"><?php echo format_price('1', "yes") ?></div> <!--center-->
    </div> <!-- BUY PREMIUM -->
    <div class="clear"></div>
    <?php } // premium button ?>


	<?php if (get_option("featuredprice") && get_post_meta(get_the_ID(), "featured", true) != "1" && get_post_type() == $taxonomy_profile_url && is_single() && get_option("paymentgateway")) { ?>
	<div class="bluebutton buyfeatured"><?php _de('Featured Position',637); ?><span class="rad3 greendegrade"><?php echo format_price('2') ?></span></div>
    <div class="buyfeatured_details blueishdegrade">
	    <?php closebtn('2') ?>
	    <?php _de('After you buy a featured position you will be placed in the header slider for maximum visibility.',638); ?> <?php _de('Only the latest',639); ?> <?php echo get_option("headerslideritems"); ?> <?php _de('%s will be shown at one time.',640,$taxonomy_profile_name_plural); ?>
		<?php
		if(get_option("featuredduration")) {
			echo "<br />"._d('Your featured status will be active for',887).' <strong>'.$payment_options_a[get_option("featuredduration")][0].'</strong> ';
			if(get_option("featuredsubscription") == "yes") {
				echo _d('and you\'ll be billed again after that period expires',885).".";
			}
		}
		?>
	    <div class="clear5"></div>
		<div class="center"><?php echo generate_payment_buttons('2',get_the_ID()); ?></div> <!--center-->
		<div class="center"><?php echo format_price('2', "yes") ?></div> <!--center-->
    </div> <!-- BUY FEATURED -->
    <div class="clear"></div>
    <?php } // featured button ?>
<?php } // if user is the author or is an escort


// Edit menu for agency users
if ($userstatus == $taxonomy_agency_url && !get_user_meta( $current_user->ID, "emailhash", true )) { ?>
	<div class="dropdownlinks dropdownlinks-dropdown">
    	<h4><span class="icon icon-menu"></span><?php _de('My Account',643); ?></h4>
        <ul>
        	<li><a href="<?php echo get_permalink(get_option("agencypostid".$userid)); ?>"><span class="icon icon-star-empty"></span> <?php _de('View my Profile',644); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('agency_edit_personal_info_page_id')); ?>"><span class="icon icon-pencil"></span> <?php _de('Edit my Profile',645); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('agency_upload_logo_page_id')); ?>"><span class="icon icon-picture"></span> <?php _de('%s Logo',653,ucfirst($taxonomy_agency_name)); ?></a></li>

			<?php if($agency_has_not_payed == "yes") { ?>
				<li><?php _de('Other edit links will be shown after payment',966); ?></li>
			<?php } else { ?>
	            <li><a href="<?php echo get_permalink(get_option('agency_manage_escorts_page_id')); ?>"><span class="icon icon-users"></span> <?php _de('Manage my %s',654,ucwords($taxonomy_profile_name_plural)); ?></a></li>
				<li><a href="<?php echo get_permalink(get_option('change_password_page_id')); ?>"><span class="icon icon-key-outline"></span><?php _de('Change Password',655); ?></a></li>
		        <?php if(get_option("hide6") != "1" && get_option("allowadpostingagencies") == "1") { ?>
		            <li><a href="<?php echo get_permalink(get_option('manage_ads_page_id')); ?>"><span class="icon icon-doc-text"></span> <?php _de('Classified Ads',294); ?></a></li>
		        <?php } ?>
				<?php if(get_option("hide5") != "1") { ?>
					<li><a href="<?php echo get_permalink(get_option('escort_blacklist_clients_page_id')); ?>"><span class="icon icon-block"></span> <?php _de('Blacklisted Clients',650); ?></a></li>
				<?php } ?>
		        <?php if(get_option("hide4") != "1") { ?>
		            <li><a href="<?php echo get_permalink(get_option('blacklisted_escorts_page_id')); ?>"><span class="icon icon-block"></span> <?php _de('Blacklisted %s',657,ucfirst($taxonomy_profile_name_plural)); ?></a></li>
		        <?php } ?>
			<?php } // if $agency_has_not_payed != yes ?>

            <li><a href="<?php echo wp_logout_url(home_url()."/"); ?>"><span class="icon icon-logout"></span> <?php _de('LogOut',651); ?></a></li>
        </ul>
	    <div class="clear"></div>
	</div> <!-- agency options -->
    <div class="clear"></div>
	<?php
} // if agency

// Edit menu for independent profile users
if ($userstatus == $taxonomy_profile_url && !get_user_meta( $current_user->ID, "emailhash", true )) { ?>
	<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('.dropdownlinks-profile ul').show('fast');
	});
	</script>
	<div class="dropdownlinks dropdownlinks-dropdown dropdownlinks-profile">
    	<h4><span class="icon icon-menu"></span><?php _de('My Account',643); ?></h4>
        <ul>
			<li><a href="<?php echo get_permalink(get_option('escortpostid'.$userid)); ?>"><span class="icon icon-star-empty"></span> <?php _de('View my Profile',644); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('escort_edit_personal_info_page_id')); ?>"><span class="icon icon-pencil"></span> <?php _de('Edit my Profile',645); ?></a></li>
		<?php if($escort_has_not_payed == "yes") { ?>
			<li><?php _de('Other edit links will be shown after payment',966); ?></li>
		<?php } else { ?>
			<?php if(get_option("hide8") != "1") { ?>
				<li><a href="<?php echo get_permalink(get_option('escort_tours_page_id')); ?>"><span class="icon icon-suitcase"></span> <?php _de('Manage my Tours',647); ?></a></li>
			<?php } ?>
	        <?php if(get_option("hide6") != "1" && get_option("allowadpostingprofiles") == "1") { ?>
	            <li><a href="<?php echo get_permalink(get_option('manage_ads_page_id')); ?>"><span class="icon icon-doc-text"></span> <?php _de('Classified Ads',294); ?></a></li>
	        <?php } ?>
			<li><a href="<?php echo get_permalink(get_option('change_password_page_id')); ?>"><span class="icon icon-key-outline"></span> <?php _de('Change Password',648); ?></a></li>
			<?php if(get_option("hide7") != "1") { ?>
				<li><a href="<?php echo get_permalink(get_option('escort_verified_status_page_id')); ?>"><span class="icon icon-check"></span> <?php _de('Verified status',627); ?></a></li>
			<?php } ?>
			<?php if(get_option("hide5") != "1") { ?>
				<li><a href="<?php echo get_permalink(get_option('escort_blacklist_clients_page_id')); ?>"><span class="icon icon-block"></span> <?php _de('Blacklisted Clients',650); ?></a></li>
			<?php } ?>
		<?php } // ?>
            <li><a href="<?php echo wp_logout_url(home_url()."/"); ?>"><span class="icon icon-logout"></span> <?php _de('LogOut',651); ?></a></li>
        <?php if(!get_post_meta(get_option('escortpostid'.$userid), 'notactive', true) && !get_post_meta(get_option('escortpostid'.$userid), 'needs_payment', true)) { ?>
            <li>&nbsp;</li>
			<li>
				<?php
				$button_text = (get_post_status(get_option('escortpostid'.$userid)) == "publish") ? _d('Set to private',1249) : _d('Activate profile',846);
				?>
				<form action="<?php echo get_permalink(get_option('escortpostid'.$userid)); ?>" method="post" class="text-center">
					<input type="hidden" name="action" value="settoprivate" />
					<input type="submit" name="submit" value="<?=$button_text?>" class="bluebutton center rad25<?php if(get_post_status(get_option('escortpostid'.$userid)) == "publish") echo " redbutton"; ?>" />
				</form>
			</li>
		<?php } ?>
        </ul>
	    <div class="clear"></div>
	</div> <!-- profile my account -->
    <div class="clear"></div>
	<?php
} // if profile

// Edit menu for members
if ($userstatus == "member" && !get_user_meta( $current_user->ID, "emailhash", true )) { ?>
	<div class="dropdownlinks dropdownlinks-dropdown">
    	<h4><span class="icon icon-user"></span><?php _de('My Account',643); ?></h4>
        <ul>
			<li><a href="<?php echo get_permalink(get_option('member_favorite_escorts_page_id')); ?>"><span class="icon icon-heart"></span> <?php _de('My Favourite %s',659,ucwords($taxonomy_profile_name_plural)); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('member_edit_personal_info_page_id')); ?>"><span class="icon icon-pencil"></span><?php _de('Edit my Profile',645); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('change_password_page_id')); ?>"><span class="icon icon-key-outline"></span><?php _de('Change Password',648); ?></a></li>
	        <?php if(get_option("hide6") != "1" && get_option("allowadpostingmembers") == "1") { ?>
	            <li><a href="<?php echo get_permalink(get_option('manage_ads_page_id')); ?>"><span class="icon icon-doc-text"></span> <?php _de('Classified Ads',294); ?></a></li>
	        <?php } ?>
			<?php if(get_option("hide1") != "1") { ?>
	            <li><a href="<?php echo get_permalink(get_option('member_reviews_page_id')); ?>"><span class="icon icon-doc-text"></span><?php _de('My reviews',1056); ?></a></li>
            <?php } ?>
            <li><a href="<?php echo wp_logout_url(home_url()."/"); ?>"><span class="icon icon-logout"></span><?php _de('LogOut',651); ?></a></li>
        </ul>
	    <div class="clear"></div>
	</div> <!-- member my account -->
    <div class="clear"></div>
<?php } // if member

// edit escort dropdown menu for agencies and admins
if (is_single() && get_post_type() == $taxonomy_profile_url && ((get_the_author_meta('ID') == $userid && $userstatus == $taxonomy_agency_url) || current_user_can('level_10'))) {
	if (get_post_type() == $taxonomy_profile_url && is_single()) {?>
	<?php if ($ok && $_POST['action'] == 'manuallyunlockescort') { echo "<div class=\"ok\">$ok</div>"; } ?>
	<div class="agencyeditbuttons dropdownlinks dropdownlinks-dropdown">
	    <h4><span class="icon icon-user"></span><?php _de('Edit %s',624,$taxonomy_profile_name); ?></h4>
        <ul>
		<?php if($escort_from_agency_has_not_payed == "yes" && !current_user_can('level_10')) { ?>
			<li><?php _de('Other edit links will be shown after payment',966); ?></li>
		<?php } else { ?>
	    	<li><a class="editprofile"><span class="icon icon-pencil"></span> <?php _de('Edit Profile',88); ?></a></li>
			<?php if(get_option("hide8") != "1") { ?>
	    	<li><a class="addtours"><span class="icon icon-suitcase"></span> <?php _de('Add Tours',626); ?></a></li>
	    	<?php } ?>
			<?php if(get_option("hide7") != "1") { ?>
	    	<li><a class="verified_status"><span class="icon icon-check"></span> <?php _de('Verified status',627); ?></a></li>
	    	<?php } ?>
		<?php } ?>

		<?php
		if (current_user_can('level_10')) {
			if (isset($_POST['action']) && $_POST['action'] == 'manuallyunlockescort') {
				$userid = (int)$_POST['userid'];
				$unlocked_escorts = get_user_meta($userid, 'unlocked_escorts', true);
				$unlocked_escorts[] = get_the_ID();
				update_user_meta($userid, 'unlocked_escorts', array_unique($unlocked_escorts));
				$ok = _d('The %s profile has been unlocked',927,$taxonomy_profile_name);
			}
		?>
			<li><a class="addanote"><span class="icon icon-doc-text"></span> <?php _de('Add a note',628); ?></a></li>
			<li>
				<div class="clear10"></div>
				<div class="upgradeescortparent">
					<div class="upgradeescortbox rad3 center">
						<?php closebtn('2') ?>
						<form action="" method="post">
							<input type="hidden" name="action" value="manuallyunlockescort" />
							<?php _de('Enter the ID of the user you want to allow to view the hidden sections of this %s',1002,$taxonomy_profile_name); ?>:
							<div class="clear5"></div>
							<input type="text" class="input" name="userid" value="" size="4" />
							<input type="submit" name="submit" class="bluebutton rad3" value="<?php _de('Unlock',1003); ?>" />
						</form>
						<div class="clear5"></div>
					</div>
					<div class="upgradebuttons">
						<div class="upgradebutton bluebutton rad3 l"><?php _de('Unlock %s for a user',1001,$taxonomy_profile_name); ?></div>
					</div>
				</div> <!-- upgrade parent unlock profile -->

				<div class="clear10"></div>

	            <form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
					<input type="hidden" name="action" value="escortupgrade" />
					<?php
					$premium_status = get_post_meta(get_the_ID(), "premium", true);
					$featured_status = get_post_meta(get_the_ID(), "featured", true);
					$expiration_status = get_post_meta(get_the_ID(), "escort_expire", true);
					?>
					<div class="upgradeescortparent">
						<div class="upgradebuttons">
							<div class="upgradebutton bluebutton rad3 l"><?php _de('Premium',631); ?></div>
							<?php if ($premium_status == "1") { ?>
								<input type="submit" name="delpremium" value="X" class="xbutton bluebutton rad3 redbutton r" />
							<?php } ?>
						</div>
						<div class="upgradeescortbox rad3">
							<?php closebtn('2') ?>
							<?php if ($premium_status == "1") { echo _d('Extend expiration with',899).":<br />"; } else { echo _d('Add premium status for',1054).":<br />"; } ?>
							<div class="clear5"></div>
							<div class="center">
							<select name="premiumduration">
								<option value=""><?php _de('Forever',822); ?></option>
		        				<?php foreach($payment_options_a as $key=>$p) { echo '<option value="'.$key.'">'.$p[0].'</option>'."\n"; } ?>
							</select>
							</div> <!--center-->
							<div class="clear10"></div>
								<input type="submit" name="premium" value="<?php if ($premium_status == "1") { echo _d('Extend',897)." "; } else { echo _d('Add',630)." "; } ?><?php _de('Premium',631); ?>" class="bluebutton rad3 l" />
							<?php if ($premium_status == "1") { ?>
								<input type="submit" name="delpremium" value="X" class="xbutton bluebutton rad3 redbutton r" />
							<?php } ?>
							<div class="clear"></div>
						</div> <!-- premium -->
					</div> <!-- upgradeescortparent premium -->
					<div class="clear10"></div>

					<div class="upgradeescortparent">
						<div class="upgradebuttons">
							<div class="upgradebutton bluebutton rad3 l"><?php _de('Featured',633); ?></div>
						<?php if ($featured_status == "1") { ?>
							<input type="submit" name="delfeatured" value="X" class="xbutton bluebutton rad3 redbutton r delbtn" />
						<?php } ?>
						</div>
						<div class="upgradeescortbox rad3">
							<?php closebtn('2') ?>
							<?php if ($featured_status == "1") { echo _d('Extend expiration with',899).":<br />"; } else { echo _d('Add featured status for',1055).":<br />"; } ?>
							<div class="clear5"></div>
							<div class="center">
							<select name="featuredduration">
								<option value=""><?php _de('Forever',822); ?></option>
		        				<?php foreach($payment_options_a as $key=>$p) { echo '<option value="'.$key.'">'.$p[0].'</option>'."\n"; } ?>
							</select>
							</div> <!--center-->
							<div class="clear10"></div>
							<input type="submit" name="featured" value="<?php if ($featured_status == "1") { echo _d('Extend',897)." "; } else { echo _d('Add',630)." "; } ?><?php _de('Featured',633); ?>" class="bluebutton rad3 l" />
							<?php if ($featured_status == "1") { ?>
								<input type="submit" name="delfeatured" value="X" class="xbutton bluebutton rad3 redbutton r" />
							<?php } ?>
							<div class="clear"></div>
						</div> <!-- featured -->
					</div> <!-- upgradeescortparent featured -->
					<div class="clear10"></div>

					<div class="upgradeescortparent">
						<div class="upgradebuttons">
							<div class="upgradebutton bluebutton rad3 l"><?php _de('Profile expiration',1238); ?></div>
						<?php if ($expiration_status) { ?>
							<input type="submit" name="delexpiration" value="X" class="xbutton bluebutton rad3 redbutton r delbtn" />
						<?php } ?>
						</div>
						<div class="upgradeescortbox rad3">
							<?php closebtn('2') ?>
							<?php if ($expiration_status) { echo _d('Extend expiration period with',1240).":<br />"; } else { echo _d('Profile will expire after',1239).":<br />"; } ?>
							<div class="clear5"></div>
							<div class="center">
							<select name="profileduration">
								<option value=""><?php _de('Forever',822); ?></option>
		        				<?php foreach($payment_options_a as $key=>$p) { echo '<option value="'.$key.'">'.$p[0].'</option>'."\n"; } ?>
							</select>
							</div> <!--center-->
							<div class="clear10"></div>
							<input type="submit" name="expirationperiod" value="<?php if ($expiration_status) { echo _d('Extend',897)." "; } else { echo _d('Add',630)." "; } ?><?php _de('Expiration',1241); ?>" class="bluebutton rad3 l" />
							<?php if ($expiration_status) { ?>
								<input type="submit" name="delexpiration" value="X" class="xbutton bluebutton rad3 redbutton r" />
							<?php } ?>
							<div class="clear"></div>
						</div> <!-- registration-expiration -->
					</div> <!-- upgradeescortparent registration-expiration -->
					<div class="clear10"></div>

					<input type="submit" name="verified" value="<?php if (get_post_meta(get_the_ID(), "verified", true) == "1") { echo _d('Remove',629)." "; } else { echo _d('Mark as',630)." "; } ?><?php _de('Verified',632); ?>" class="bluebutton rad3 l<?php if (get_post_meta(get_the_ID(), "verified", true) == "1") { echo " redbutton"; } ?>" /><div class="clear10"></div>
				</form>
            </li>
		<?php } // if is admin ?>
		<?php if(!get_post_meta(get_option('escortpostid'.$userid), 'notactive', true)) { ?>
			<li>
				<?php
				$button_text = (get_post_status(get_the_ID()) == "publish") ? _d('Set to private',1249) : _d('Activate profile',846);
				?>
				<form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
					<input type="hidden" name="action" value="settoprivate" />
					<input type="submit" name="submit" value="<?=$button_text?>" class="bluebutton rad3<?php if(get_post_status(get_the_ID()) == "publish") echo " redbutton"; ?>" />
				</form>
				<div class="clear10"></div>
			</li>
		<?php } ?>
			<li><a class="delete"><span class="redbutton rad3"><?php _de('Delete',89); ?></span></a></li>
        </ul>
        <div class="clear"></div>
	</div> <!-- AGENCY EDIT BUTTONS -->
    <div class="clear"></div>
	<?php
	} // if post_type is escort
} // if agency or admin

// admin menu dropdown
if (current_user_can('level_10')) {
	// edit agency dropdown menu for admins
	if (is_single() && get_post_type() == $taxonomy_agency_url) { ?>
		<script type="text/javascript">
			jQuery(document).ready(function($) {
				$('.admineditbuttons .addprofile').on('click', function(){
					$('.bodybox').hide();
					$('.agency_options_add_profile').slideDown('fast');
				});
				$('.admineditbuttons .editprofile').on('click', function(){
					$('.bodybox').hide();
					$('.agency_options_edit_agency').slideDown('fast');
				});
				$('.admineditbuttons .deleteprofile').on('click', function(){
					$('.bodybox').hide();
					$('.agency_options_delete').slideDown('fast');
				});

				$('.agency_options_add_profile .closebtn, .agency_options_edit_agency .closebtn, .agency_options_delete .closebtn').on('click', function(){
					$('.bodybox').slideDown('fast');
					$('.agency_options_add_profile, .agency_options_edit_agency, .agency_options_delete').hide();
				});
			});
		</script>

		<div class="admineditbuttons dropdownlinks dropdownlinks-dropdown">
		    <h4><span class="icon icon-user"></span><?php _de('Edit %s',624,$taxonomy_agency_name); ?></h4>
	        <ul>
		    	<li><a class="editprofile"><span class="icon icon-pencil"></span> <?php _de('Edit Profile',88); ?></a></li>
		    	<li><a class="addprofile"><span class="icon icon-user"></span> <?php _de('Add %s',662,$taxonomy_profile_name); ?></a></li>
		    	<li>
		    		<div class="clear10"></div>
		            <form action="<?php echo get_permalink(get_the_ID()); ?>" method="post">
						<input type="hidden" name="action" value="agencyupgrade" />
						<?php
						$expiration_status = get_post_meta(get_the_ID(), "agency_expire", true);
						?>
						<div class="upgradeescortparent">
							<div class="upgradebuttons">
								<div class="upgradebutton bluebutton rad3 l"><?php _de('Profile expiration',1238); ?></div>
							<?php if ($expiration_status) { ?>
								<input type="submit" name="delexpiration" value="X" class="xbutton bluebutton rad3 redbutton r delbtn" />
							<?php } ?>
							</div>
							<div class="upgradeescortbox rad3">
								<?php closebtn('2') ?>
								<?php if ($expiration_status) { echo _d('Extend expiration period with',1240).":<br />"; } else { echo _d('Profile will expire after',1239).":<br />"; } ?>
								<div class="clear5"></div>
								<div class="center">
								<select name="profileduration">
									<option value=""><?php _de('Forever',822); ?></option>
			        				<?php foreach($payment_options_a as $key=>$p) { echo '<option value="'.$key.'">'.$p[0].'</option>'."\n"; } ?>
								</select>
								</div> <!--center-->
								<div class="clear10"></div>
								<input type="submit" name="expirationperiod" value="<?php if ($expiration_status) { echo _d('Extend',897)." "; } else { echo _d('Add',630)." "; } ?><?php _de('Expiration',1241); ?>" class="bluebutton rad3 l" />
								<?php if ($expiration_status) { ?>
									<input type="submit" name="delexpiration" value="X" class="xbutton bluebutton rad3 redbutton r" />
								<?php } ?>
								<div class="clear"></div>
							</div> <!-- registration-expiration -->
						</div> <!-- upgradeescortparent registration-expiration -->
						<div class="clear10"></div>

					</form>
		    	</li>
		    	<li><a class="deleteprofile"><span class="redbutton rad3 l"><?php _de('Delete',89); ?></span></a></li>
		    </ul>
	        <div class="clear"></div>
		</div> <!-- AGENCY EDIT BUTTONS -->
	    <div class="clear"></div>
	<?php } // show edit links for admin on agency pages

	// Activate tour process
	if (isset($_POST['action']) && $_POST['action'] == 'manuallyactivatetour') {
		$tourid = (int)$_POST['tourid'];
		$post_tour = array( 'ID' => $tourid, 'post_status' => 'publish' );
		// activate the tour
		wp_update_post( $post_tour );
		$ok = _d('The tour has been activated',997);
	}
	// Activate VIP process
	if (isset($_POST['action']) && $_POST['action'] == 'manuallyactivatevip') {
		$userid = (int)$_POST['userid'];
		$vipduration = (int)$_POST['vipduration'];
		if ( isset($_POST['addvip']) && $_POST['userid'] ) {
			update_user_meta($userid, 'vip', "1");
			$expiration = strtotime("+".$payment_options_a[$vipduration][3]." ".$payment_options_a[$vipduration][1]);
			$available_time = get_user_meta($custom, 'vip_expire', true);
			if($available_time && $available_time > time()) {
				$expiration = $expiration + ($available_time - time());
				$ok = _d('The user\'s VIP status has been extended',998);
			} else {
				$ok = _d('The user now has VIP status',999);
			}
			if($vipduration) {
				update_user_meta($userid, 'vip_expire', $expiration); // when does the VIP status expire
			} else {
				delete_user_meta($userid, 'vip_expire');
			}
		}
		if ( isset($_POST['removevip']) && $_POST['userid'] ) {
			delete_user_meta($userid, 'vip');
			delete_user_meta($userid, 'vip_expire');
			$ok = _d('The VIP status has been removed from the user',1000);
		}
	}

	// Admin menu links
	if ( $ok && ($_POST['action'] == 'manuallyactivatetour' || $_POST['action'] == 'manuallyactivatevip')) { echo "<div class=\"ok\">$ok</div>"; } ?>
	<div class="dropdownlinks dropdownlinks-dropdown">
    	<h4><span class="icon icon-menu"></span><?php _de('Admin Links',661); ?></h4>
        <ul>
        	<li><a href="<?php echo get_permalink(get_option('escort_reg_page_id')); ?>"><span class="icon icon-user"></span> <?php _de('Add %s',662,$taxonomy_profile_name); ?></a></li>
        	<li><a href="<?php echo get_permalink(get_option('agency_reg_page_id')); ?>"><span class="icon icon-user"></span> <?php _de('Add %s',662,$taxonomy_agency_name); ?></a></li>
        	<li><a class="manuallyactivatevip"><span class="icon icon-user"></span> <?php _de('VIP user',1089); ?></a></li>
        	<li><a class="manuallyactivatetour"><span class="icon icon-suitcase"></span> <?php _de('Activate tour',788); ?></a></li>
            <?php if(get_option("hide6") != "1") { ?>
            <li><a href="<?php echo get_permalink(get_option('manage_ads_page_id')); ?>"><span class="icon icon-doc-text"></span> <?php _de('Classified Ads',294); ?></a></li>
            <?php } ?>
			<?php if(get_option("hide5") != "1") { ?>
			<li><a href="<?php echo get_permalink(get_option('escort_blacklist_clients_page_id')); ?>"><span class="icon icon-block"></span> <?php _de('Blacklisted Clients',650); ?></a></li>
			<?php } ?>
			<?php if(get_option("hide4") != "1") { ?>
            <li><a href="<?php echo get_permalink(get_option('blacklisted_escorts_page_id')); ?>"><span class="icon icon-block"></span> <?php _de('Blacklisted %s',657,ucfirst($taxonomy_profile_name_plural)); ?></a></li>
            <?php } ?>
        	<li>

			<div class="upgradeescortbox manuallyactivatetour_div ok rad5">
				<?php closebtn('2') ?>
				<form action="" method="post">
					<input type="hidden" name="action" value="manuallyactivatetour" />
					<?php _de('Enter the tour ID',993); ?>:
					<div class="clear10"></div>
					<input type="text" class="input" name="tourid" value="" size="5" />
					<div class="clear10"></div>
					<input type="submit" name="submit" class="bluebutton rad3" value="<?php _de('Activate tour',788); ?>" />
				</form>
			</div> <!-- manually activate tour -->

			<div class="upgradeescortbox manuallyactivatevip_div ok rad5">
				<?php closebtn('2') ?>
				<form action="" method="post">
					<input type="hidden" name="action" value="manuallyactivatevip" />
					<?php _de('Enter the user ID you want to make VIP',994); ?>:
					<div class="clear10"></div>
					<input type="text" class="input" name="userid" value="" size="5" />
					<div class="clear10"></div>
					<div class="center">
					<?php _de('VIP lasts for',996); ?>: 
					<select name="vipduration">
						<option value=""><?php _de('Forever',822); ?></option>
						<?php foreach($payment_options_a as $key=>$p) { echo '<option value="'.$key.'">'.$p[0].'</option>'."\n"; } ?>
					</select>
					</div> <!--center-->
					<div class="clear10"></div>
					<input type="submit" name="addvip" class="bluebutton rad3" value="<?php _de('Activate/Extend VIP user',992); ?>" />
					<div class="clear10"></div>
					<input type="submit" name="removevip" class="redbutton rad3" value="<?php _de('Remove VIP from user',995); ?>" />
				</form>
			</div> <!-- manually activate VIP -->

        	</li>
            <li>&nbsp;</li>
            <li><a href="<?php echo get_permalink(get_option('site_settings_page_id')); ?>"><span class="icon icon-cog-alt"></span> <?php _de('Site Settings',663); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('hide_site_sections_page_id')); ?>"><span class="icon icon-cog-alt"></span> <?php _de('Content settings',799); ?></a></li>
			<li><a href="<?php echo get_permalink(get_option('edit_registration_form_escort')); ?>"><span class="icon icon-cog-alt"></span> <?php _de('Registration Form',1006); ?></a></li>
            <li><a href="<?php echo get_permalink(get_option('edit_payment_settings_page_id')); ?>"><span class="icon icon-dollar"></span> <?php _de('Payment Settings',664); ?></a></li>
            <li><a href="<?php echo get_permalink(get_option('email_settings_page_id')); ?>"><span class="icon icon-mail"></span> <?php _de('Email Settings',665); ?></a></li>
            <li><a href="<?php echo get_permalink(get_option('edit_user_types')); ?>"><span class="icon icon-user"></span> <?php _de('Edit user types',1138); ?></a></li>
            <li><a href="<?php bloginfo('url'); ?>/wp-admin/edit-tags.php?taxonomy=<?php echo $taxonomy_location_url; ?>&amp;post_type=<?php echo $taxonomy_profile_url; ?>"><span class="icon icon-plus-circled"></span> <?php _de('Add countries',1024); ?></a></li>
            <li><a href="<?php echo get_permalink(get_option('generate_demo_data_page')); ?>"><span class="icon icon-plus-circled"></span> <?php _de('Generate demo data',1101); ?></a></li>
            <li><a href="<?php echo get_bloginfo('url')."/wp-admin/"; ?>"><span class="icon icon-w"></span> <?php _de('Wordpress Admin',666); ?></a></li>
            <li>&nbsp;</li>
            <li><a href="<?php echo wp_logout_url(home_url()."/"); ?>"><span class="icon icon-logout"></span> <?php _de('LogOut',651); ?></a></li>
        </ul>
	    <div class="clear"></div>
	</div> <!-- ADMIN LINKS -->
    <div class="clear"></div>

	<?php if((get_post_type() == $taxonomy_profile_url || get_post_type() == $taxonomy_agency_url || get_post_type() == "ad" || get_post_type() == "review") && is_single()) { ?>
		<div class="dropdownlinks">
			<h4><span class="icon icon-cog-alt"></span><?php _de('User details',1043); ?>:</h4>
			<div class="clear5"></div>
			<small><?php _de('User ID',1044); ?></small>: <b><?php echo get_the_author_meta('ID'); ?></b><br />
			<small><?php _de('Username',409); ?></small>: <b><?php echo get_the_author_meta(user_login ); ?></b><br />
			<small><?php _de('Email',48); ?></small>: <b><?php echo get_the_author_meta(user_email); ?></b><br />
			<?php if(get_option('escortid'.get_the_author_meta('ID'))) { ?>
			<small><?php _de('Type',320); ?></small>: <b><?php echo get_option('escortid'.get_the_author_meta('ID')); ?></b>
			<?php } ?>
			<div class="clear5"></div>
			<a href="<?php echo get_bloginfo('url')."/wp-admin/user-edit.php?user_id=".get_the_author_meta('ID'); ?>"><?php _de('Edit user',1087); ?></a>
	        <div class="clear"></div>
		</div>
        <div class="clear"></div>
	<?php } // if is_single() ?>
	<?php
} // if super admin

// show agency expiration date
if(is_single() && get_post_meta(get_the_ID(), "agency_expire", true) && (get_the_author_meta('ID') == $userid || current_user_can('level_10')) && get_post_type() == $taxonomy_agency_url) {
	$agency_expire_date = date("d M Y", get_post_meta(get_the_ID(), "agency_expire", true));

	echo '<div class="sidebar_expire_notice bluedegrade center">';
	echo '<small>'._d('Your %s profile is active until',1235,$taxonomy_agency_name).':</small><b>'.$agency_expire_date.'</b>';

	if(get_post_meta(get_the_ID(), "agency_renew", true)) {
		// cancel subscription button
	} elseif (get_post_meta(get_the_ID(), "agency_expire", true) && get_option("agregprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
	    echo '<div class="clear10"></div>';
		echo '<div class="center">'.generate_payment_buttons('6',get_the_ID(),_d('Extend registration',1236)).'</div> <!--center-->';
		echo '<div class="center">'.format_price('6', "yes").'</div> <!--center-->';
	}

	echo '</div>';
}

// show profile expiration date
if(is_single() && get_post_meta(get_the_ID(), "escort_expire", true) && (get_the_author_meta('ID') == $userid || current_user_can('level_10')) && get_post_type() == $taxonomy_profile_url) {
	$escort_expire_date = date("d M Y", get_post_meta(get_the_ID(), "escort_expire", true));

	if($userstatus == $taxonomy_agency_url) {
		echo '<div class="sidebar_expire_notice bluedegrade center">';
		echo '<small>'._d('The %s profile you added is active until',1237,$taxonomy_profile_name).':</small><b>'.$escort_expire_date.'</b>';
		if(get_post_meta(get_the_ID(), "escort_renew", true)) {
			// cancel subscription button
		} elseif (get_post_meta(get_the_ID(), "escort_expire", true) && get_option("agescortregprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
		    echo '<div class="clear10"></div>';
			echo '<div class="center">'.generate_payment_buttons('8',get_the_ID(),_d('Extend registration',1236)).'</div> <!--center-->';
			echo '<div class="center">'.format_price('8', "yes").'</div> <!--center-->';
		}
	} else {
		echo '<div class="sidebar_expire_notice bluedegrade center">';
		echo '<small>'._d('Your %s profile is active until',1235,$taxonomy_profile_name).':</small><b>'.$escort_expire_date.'</b>';
		if(get_post_meta(get_the_ID(), "escort_renew", true)) {
			// cancel subscription button
		} elseif (get_post_meta(get_the_ID(), "escort_expire", true) && get_option("indescregprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
		    echo '<div class="clear10"></div>';
			echo '<div class="center">'.generate_payment_buttons('8',get_the_ID(),_d('Extend registration',1236)).'</div> <!--center-->';
			echo '<div class="center">'.format_price('8', "yes").'</div> <!--center-->';
		}
	}

	echo '</div>';
}

// show member's VIP expiration
if(is_user_logged_in() && get_user_meta($userid, 'vip', true)) {
	if(get_user_meta($userid, 'vip_expire', true)) {
		$vip_expire_date = date("d M Y", get_user_meta($userid, 'vip_expire', true));
	} else {
		$vip_expire_date = strtolower(_d('forever',822));
	}
	echo '<div class="sidebar_expire_notice bluedegrade center">';
	echo '<small>'._d('Your VIP status is active until',894).':</small><b>'.$vip_expire_date.'</b>';

	if(get_post_meta(get_the_ID(), "vip_expire", true) && get_option("vipprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
	    echo '<div class="clear10"></div>';
		echo '<div class="center">'.generate_payment_buttons('5',get_the_ID(),_d('Extend VIP',1233)).'</div> <!--center-->';
		echo '<div class="center">'.format_price('5', "yes").'</div> <!--center-->';
	}
	echo '</div>';
}

// show profile premium expiration
if(is_single() && get_post_meta(get_the_ID(), "premium", true) == "1" && get_post_meta(get_the_ID(), "needs_payment", true) != "1" && (get_the_author_meta('ID') == $userid || current_user_can('level_10'))) {
	if(get_post_meta(get_the_ID(), "premium_expire", true)) {
		$premium_expire_date = date("d M Y", get_post_meta(get_the_ID(), "premium_expire", true));
	} else {
		$premium_expire_date = strtolower(_d('forever',822));
	}

	echo '<div class="sidebar_expire_notice orangedegrade center">';
	echo '<small>'._d('Your premium status is active until',902).':</small><b>'.$premium_expire_date.'</b>';

	if(get_post_meta(get_the_ID(), "premium_expire", true) && get_option("premiumprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
	    echo '<div class="clear10"></div>';
		echo '<div class="center">'.generate_payment_buttons('1',get_the_ID(),_d('Extend premium',1231)).'</div> <!--center-->';
		echo '<div class="center">'.format_price('1', "yes").'</div> <!--center-->';
	}

	echo '</div>';
}

// show profile featured expiration
if(is_single() && get_post_meta(get_the_ID(), "featured", true) == "1" && get_post_meta(get_the_ID(), "needs_payment", true) != "1" && (get_the_author_meta('ID') == $userid || current_user_can('level_10'))) {
	if(get_post_meta(get_the_ID(), "featured_expire", true)) {
		$featured_expire_date = date("d M Y", get_post_meta(get_the_ID(), "featured_expire", true));
	} else {
		$featured_expire_date = strtolower(_d('forever',822));
	}
	echo '<div class="sidebar_expire_notice bluedegrade center">';
	echo '<small>'._d('Your featured status is active until',904).':</small><b>'.$featured_expire_date.'</b>';
	if(get_post_meta(get_the_ID(), "featured_expire", true) && get_option("featuredprice") && get_option("paymentgateway") && !current_user_can('level_10')) {
	    echo '<div class="clear10"></div>';
		echo '<div class="center">'.generate_payment_buttons('2',get_the_ID(),_d('Extend featured',1232)).'</div> <!--center-->';
		echo '<div class="center">'.format_price('2', "yes").'</div> <!--center-->';
	}
	echo '</div>';
}


// Blog categories
global $blog_section;
if($blog_section == 'yes') { ?>
	<div class="dropdownlinks blog_categories">
    	<h4><?php _de('Our Blog',1125); ?></h4>
        <ul>
			<?php
			$blog_cats = get_categories();
			foreach($blog_cats as $subcat) {
				if(!$subcat->category_parent) {
					// build code to show top categories / countries
					$cat_id = $subcat->cat_ID;
					$name = $subcat->cat_name;
					$main_cat_slug = $subcat->slug;
					$link = get_term_link((int)$cat_id, 'category');
					$title = $name; // this is for SEO purposes. in case the country link title should be different than the country name

					// build code to show subcategories / cities
					foreach($blog_cats as $subcat2) {
						if ($subcat2->category_parent == $cat_id) {
							$subcat_id = $subcat2->cat_ID;
							$subcat_name = $subcat2->cat_name;
							$subcat_link = get_term_link((int)$subcat_id, 'category');
							$subcat_title = $subcat_name;
							$li .= '<li class="cat-item cat-item-'.$subcat_id.'">'."\n";
							$li .= "&nbsp;&nbsp;&nbsp;-&nbsp;".'<a href="'.$subcat_link.'" title="'.$subcat_title.'">'.$subcat_name.'</a>'."\n";
							$li .= "</li>"."\n";
						}
						unset($current_city);
					}

					// show top categories / countries
					echo '<li class="cat-item cat-item-'.$cat_id.'">'; // start <li>
					echo '<a href="'.$link.'" title="'.$title.'">'.$name.'</a>';

					// show top categories / countries
					if ($li) {
						echo "\n".'<ul>'."\n";
						echo $li;
						echo "</ul>"."\n";
					}

					echo "</li>"."\n"; // end </li>
					unset($current, $li);
				} // if taxonomy has no parent
			} // for each main cat
			?>
        </ul>
    </div>
    <div class="clear"></div>
<?php } // if blog section ?>

<?php if(get_option("quickescortsearch") == "1") { ?>
	<div class="quicksearch">
		<script type="text/javascript">
		jQuery(document).ready(function($) {
			// get cities from the selected country in the countries dropdown
			var c = ".search-country";
			var parent_div = ".quicksearch";
			var country = $(c).val();
			<?php if(showfield('state')) { ?>
				var city_div = '.search-states-input';

				var state_c = '#state';
				var state_div = '.search-cities-input';
			<?php } else { ?>
				var city_div = '.search-cities-input';
			<?php } ?>

			if(country > 0) { show_search_cities(c); }
			$(parent_div+' '+c).change(function(){ show_search_cities(c); });
			function show_search_cities(e) {
				var country = $(parent_div+' '+e).val();
				$(parent_div+' '+city_div).text('');
				<?php if(showfield('state')) { ?>
					$(parent_div+' '+state_div).text('');
				<?php } ?>

				if(country < 1) return true;

				loader($(e).parents(parent_div).find(city_div));
				$.ajax({
					type: "GET",
					url: "<?php bloginfo('template_url'); ?>/ajax/get-cities.php",
					<?php if(showfield('state')) { ?>
						data: "id=" + country +"&selected=<?php echo $state ?>&hide_empty=1&class=col100&state=yes&select2=yes",
					<?php } else { ?>
						data: "id=" + country +"&selected=<?php echo $city ?>&hide_empty=1&class=col100&select2=yes",
					<?php } ?>
					success: function(data){
						$(e).parents(parent_div).find(city_div).html(data + '<div class="formseparator"><'+'/div>');
						if($(window).width() > "960") { $('.select2').select2(); }
					}
				});
			}

			<?php if(showfield('state')) { ?>
				$(parent_div).on("change", state_c, function(){
					show_search_cities_when_states(state_c);
				});
				function show_search_cities_when_states(e) {
					var state = $(parent_div+' '+e).val();
					$(parent_div+' '+state_div).text('');
					if(state < 1) {
						return true;
					}

					loader($(e).parents(parent_div).find(state_div));
					$.ajax({
						type: "GET",
						url: "<?php bloginfo('template_url'); ?>/ajax/get-cities.php",
						data: "id=" + state +"&selected=<?php echo $city ?>&hide_empty=1&class=col100&select2=yes",
						success: function(data){
							$(e).parents(parent_div).find(state_div).html(data + '<div class="formseparator"><'+'/div>');
							if($(window).width() > "960") { $('.select2').select2(); }
						}
					});
				}
			<?php } // if showfield('state') ?>


		});
		</script>
    	<h4><?php _de('Quick Search',667); ?>:</h4>
    	<form action="<?php echo get_permalink(get_option('search_page_id')); ?>" method="post" class="form-styling">
    		<input type="hidden" name="action" value="search" />
    		<div class="form-input col100">
			<?php
			$args = array(
			    'show_option_none'    => _d('Country',71),
			    'orderby'            => 'name',
			    'order'              => 'ASC',
			    'show_last_update'   => 0,
			    'show_count'         => 0,
			    'hide_empty'         => 1,
			    'selected'           => 0,
			    'hierarchical'       => 1, 
			    'name'               => 'country',
				'id'                 => '',
				'class'              => 'search-country col100 select2',
			    'depth'              => 1,
			    'tab_index'          => 0,
			    'taxonomy'           => $taxonomy_location_url );
			wp_dropdown_categories( $args );
			?>
			</div> <!-- country --> <div class="formseparator"></div>

			<?php if(showfield('state')) { ?>
			<div class="search-states-input form-input col100"></div>
			<?php } // if showfield('state') ?>

			<div class="search-cities-input form-input col100"></div>

			<div class="form-input col100">
                <select name="gender" class="select2">
					<?php foreach($gender_a as $key=>$gender) { if(in_array($key, $settings_theme_genders)) { echo '<option value="'.$key.'">'.$gender.'</option>'; } } ?>
                </select>
			</div> <!-- gender --> <div class="formseparator"></div>

			<div class="form-input col100">
            	<label for="prem">
            		<input type="checkbox" name="premium" value="1" id="prem" />
            		<?php _de('Only premium',670); ?>
            	</label>
            </div> <!-- premium --> <div class="formseparator"></div>

			<div class="form-input col100">
            	<label for="indep">
            		<input type="checkbox" name="independent" value="yes" id="indep" />
            		<?php _de('Only independent',669); ?>
            	</label>
            </div> <!-- premium --> <div class="formseparator"></div>

            <div class="center">
				<input type="submit" name="submit" value="<?php _de('Search',85); ?>" class="submit-button blueishbutton rad3" />
				<div class="clear5"></div>
				<a href="<?php echo get_permalink(get_option('search_page_id')); ?>" class="adv"><span class="icon icon-search"></span><?php _de('Advanced search',671); ?></a>
			</div> <!-- center -->
        </form>
        <div class="clear"></div>
    </div> <!-- QUICK SEARCH -->
    <div class="clear"></div>
<?php } // if get_option("quickescortsearch") == 1 ?>

<?php if ( is_active_sidebar('widget-sidebar-right') || current_user_can('level_10')) : ?>
<div class="widgetbox-wrapper">
	<?php if ( !dynamic_sidebar('Sidebar Right') && current_user_can('level_10')) : ?>
	<?php _de('Go to your',209); ?> <a href="<?php echo admin_url('widgets.php'); ?>"><?php _de('widgets page',210); ?></a> <?php _de('to add content here',211); ?>.
	<?php endif; ?>
</div> <!-- SIDEBAR BOX -->
<?php endif; ?>

<?php dynamic_sidebar('Right Ads'); ?>

</div> <!-- SIDEBAR RIGHT -->