<?php
if(!defined('error_reporting')) { define('error_reporting', '0'); }
ini_set( 'display_errors', error_reporting );
if(error_reporting == '1') { error_reporting( E_ALL ); }
if(isdolcetheme !== 1) { die(); }
?>

<?php if ($err) { echo "<div class=\"err rad3\">$err</div>"; } ?>
<?php
global $taxonomy_location_url, $taxonomy_agency_name;
if ($agency_post_id) {
	$form_url = get_permalink(get_option('agency_edit_personal_info_page_id'));
} else  {
	$form_url = get_permalink(get_option('agency_reg_page_id'));
}

if ($admin_editing_agency == "yes") {
	$form_url = get_permalink($agency_post_id);
}
?>
<script type="text/javascript">
jQuery(document).ready(function($) {
	//check if the current user is already taken
	$('#user').keyup(function(){
		var user = $('#user').val();
		var userlength = document.getElementById("user").value.length;
		if(userlength >= 4 && userlength <= 30) {
			$('.checkuser').empty();
			$.ajax({
				type: "GET",
				url: "<?php bloginfo('template_url'); ?>/ajax/check-username.php",
				data: "user=" + user,
				success: function(data){
					$('.checkuser').html(data);
				}
			});
		};
	});

	$('#register_form').on('submit', function(event) {
		var button = $('#register_form #register_submit');
		if(button.prop("disabled") === false) {
			button.prop("disabled",true);
			setTimeout(function() {
				button.prop("disabled",false);
			}, 2000);
		}
	});
});
</script>
<form action="<?php echo $form_url; ?>" method="post" novalidate class="form-styling register-form-ag">
	<small class="mandatory l"><?php _de('Fields marked with <i>*</i> are mandatory',323); ?></small>
	<div class="clear30"></div>

	<input type="hidden" name="action" value="register" />
    <input type="text" name="emails" value="" class="hide" />
    <?php if ($agency_post_id) { ?>
	    <input type="hidden" name="agency_post_id" value="<?php echo $agency_post_id; ?>" />
    <?php } ?>
    
    <?php if(!$agency_post_id) { ?>
	    <div class="form-label">
			<label for="user"><?php _de('Username',409); ?><i>*</i></label>
			<small class="checkuser"><?php _de('Between 4 and 30 characters',410); ?></small>
		</div>
		<div class="form-input">
	    	<input type="text" name="user" id="user" class="input longinput" value="<?php echo $user; ?>" autocomplete="off" />
		</div> <!-- username --> <div class="formseparator"></div>

		<div class="form-label">
	    	<label for="pass"><?php _de('Password',411); ?><i>*</i></label>
	    	<small><?php _de('Must be between 6 and 30 characters',412); ?></small>
	    </div>
		<div class="form-input">
	    	<input type="password" name="pass" id="pass" class="input longinput" value="<?php echo $pass; ?>" autocomplete="off" />
	    </div> <!-- password --> <div class="formseparator"></div>
    <?php } // if !$agency_post_id ?>

    <div class="form-label">
    	<label for="agencyemail"><?php _de('Email',48); ?><i>*</i></label>
    </div>
	<div class="form-input">
    	<input type="email" name="agencyemail" id="agencyemail" class="input longinput" value="<?php echo $agencyemail; ?>" />
    </div> <!-- email --> <div class="formseparator"></div>

	<?php if(current_user_can('level_10') && !$agency_post_id) { ?>
		<div class="form-label">
	    	<label><?php _de('Send verification email',1045); ?></label>
	    </div>
		<div class="form-input">
			<label for="sendverificationyes"><input type="radio" id="sendverificationyes" name="sendverification" value="1" <?php if($sendverification == "1") { echo ' checked'; } ?> /><?php _de('Yes',156); ?></label>
			<label for="sendverificationno"><input type="radio" id="sendverificationno" name="sendverification" value="2" <?php if($sendverification == "2") { echo ' checked'; } ?> /><?php _de('No',157); ?></label>
			<div class="clear10"></div>
			<small>
				<i>!</i> <?php _de('Send a validation link to the email. The user has to click that link in order to activate the account and verify that the email is valid.',1046); ?><br />
				<i>!</i> <?php _de('If you choose not to send a validation link then the account will be activated by default.',1047); ?>
			</small>
		</div> <!-- send verification email --> <div class="formseparator"></div>

		<div class="form-label">
	    	<label><?php _de('Send username and password by email',1078); ?></label>
	    </div>
		<div class="form-input">
			<label for="sendauthyes"><input type="radio" id="sendauthyes" name="sendauth" value="1" <?php if($sendauth == "1") { echo ' checked'; } ?> /><?php _de('Yes',156); ?></label>
			<label for="sendauthno"><input type="radio" id="sendauthno" name="sendauth" value="2" <?php if($sendauth == "2") { echo ' checked'; } ?> /><?php _de('No',157); ?></label>
	    </div> <!-- send user and pass in email --> <div class="formseparator"></div>
	    <div class="clear30"></div>
	<?php } // if admin ?>

	<div class="form-label">
    	<label for="agencyname"><?php _de('%s Name',519,ucfirst($taxonomy_agency_name)); ?><i>*</i></label>
    </div>
	<div class="form-input">
    	<input type="text" name="agencyname" id="agencyname" class="input longinput" value="<?php echo $agencyname; ?>" />
    </div> <!-- agency name --> <div class="formseparator"></div>

    <div class="form-label">
    	<label for="phone"><?php _de('Phone',49); ?><i>*</i></label>
    </div>
	<div class="form-input">
    	<input type="tel" name="phone" id="phone" class="input longinput" value="<?php echo $phone; ?>" />
    </div> <!-- phone --> <div class="formseparator"></div>

    <div class="form-label">
    	<label for="website"><?php _de('Website',368); ?></label>
    </div>
	<div class="form-input">
		<input type="url" name="website" id="website" class="input longinput" value="<?php echo $website; ?>" />
	</div> <!-- website --> <div class="formseparator"></div>

   	<?php if(get_option('locationdropdown') == "1") { ?>
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			//get cities from the selected country in the countries dropdown
			var c = ".country";
			var parent_div = ".register-form-ag";
			<?php if(showfield('state')) { ?>
				var city_div = '.inputstates';

				var state_c = '.state';
				var state_div = '.inputcities';
			<?php } else { ?>
				var city_div = '.inputcities';
			<?php } ?>

			$(parent_div+' '+c).on('change', function(event) {
				show_search_cities(c);
			});
			function show_search_cities(e) {
				var country = $(parent_div+' '+e).val();
				$(parent_div+' '+city_div).text($(city_div).data('text'));
				<?php if(showfield('state')) { ?>
					$(parent_div+' '+state_div).text($(state_div).data('text'));
				<?php } ?>

				if(country < 1) return true;

				loader($(e).parents(parent_div).find(city_div));
				$.ajax({
					type: "GET",
					url: "<?php bloginfo('template_url'); ?>/ajax/get-cities.php",
					<?php if(showfield('state')) { ?>
						data: "id=" + country +"&hide_empty=0&state=yes&select2=yes",
					<?php } else { ?>
						data: "id=" + country +"&hide_empty=0&select2=yes",
					<?php } ?>
					success: function(data){
						$(e).parents(parent_div).find(city_div).html(data);
						if($(window).width() > "960") { $('.select2').select2(); }
					}
				});
			}

			<?php if(showfield('state')) { ?>
				$(parent_div).on("change", state_c, function(){
					show_search_cities_when_states(state_c);
				});
				function show_search_cities_when_states(e) {
					var state = $(parent_div+' '+e).val();
					$(parent_div+' '+state_div).text($(state_div).data('text'));
					if(state < 1) {
						return true;
					}

					loader($(e).parents(parent_div).find(state_div));
					$.ajax({
						type: "GET",
						url: "<?php bloginfo('template_url'); ?>/ajax/get-cities.php",
						data: "id=" + state +"&hide_empty=0&select2=yes",
						success: function(data){
							$(e).parents(parent_div).find(state_div).html(data);
							if($(window).width() > "960") { $('.select2').select2(); }
						}
					});
				}
			<?php } // if showfield('state') ?>
		});
	</script>
	<?php } // if the city and state need to be dropdowns ?>
	<div class="form-label">
		<label for="country"><?php _de('Country',80); ?><i>*</i></label>
	</div>
	<div class="form-input">
		<?php
		$args = array(
			'show_option_none'   => _d('Select country',402),
			'hide_empty'         => 0,
			'echo'               => 1,
			'selected'           => $country,
			'hierarchical'       => 1,
			'name'               => 'country',
			'id'                 => 'country',
			'class'              => 'country select2',
			'depth'              => 1,
		    'orderby'            => 'name',
		    'order'              => 'ASC',
			'taxonomy'           => $taxonomy_location_url );
		wp_dropdown_categories( $args );
		$city_parent = $country;
		?>
    </div> <!-- country --> <div class="formseparator"></div>

	<?php if(showfield('state')) { ?>
	<div class="form-label">
		<label for="state"><?php _de('State',76); ?><i>*</i></label>
	</div>
	<div class="form-input inputstates" data-text="<?=_d('Please select a country first',388)?>">
		<?php if(get_option('locationdropdown') == "1") {
				if($country > 0) {
					$city_parent = $state;
					$args = array(
						'show_option_all'    => '',
						'show_option_none'   => _d('Select State',1211),
						'show_last_update'   => 0,
						'show_count'         => 0,
						'parent'			 => $country,
						'hide_empty'         => 0,
						'exclude'            => '',
						'echo'               => 1,
						'selected'           => $state,
						'hierarchical'       => 1, 
						'name'               => 'state',
						'id'                 => '',
						'class'              => 'state select2',
						'depth'              => 1,
						'tab_index'          => 0,
					    'orderby'            => 'name',
					    'order'              => 'ASC',
						'taxonomy'           => $taxonomy_location_url );
					wp_dropdown_categories( $args );
				} else {
					_de('Please select a country first',388);
				}
		} else { ?>
			<input type="text" name="state" id="state" class="input longinput" value="<?php echo $state; ?>" />
		<?php } ?>
	</div> <!-- state --> <div class="formseparator"></div>
   	<?php } ?>

    <div class="form-label">
		<label for="city"><?php _de('City',81); ?> <i>*</i></label>
	</div>
	<?php
	if(showfield('state')) {
		$city_text = _d('Please select a state first',1212);
	} else {
		$city_text = _d('Please select a country first',388);
	}
	?>
	<div class="form-input inputcities" data-text="<?=$city_text?>">
		<?php
		 if(get_option('locationdropdown') == "1") {
			if(($country > 0 && !showfield('state')) || ($state > 0 && showfield('state'))) {
				$args = array(
					'show_option_all'    => '',
					'show_option_none'   => _d('Select City',387),
					'show_last_update'   => 0,
					'show_count'         => 0,
					'parent'			 => $city_parent,
					'hide_empty'         => 0,
					'exclude'            => '',
					'echo'               => 1,
					'selected'           => $city_id,
					'hierarchical'       => 1, 
					'name'               => 'city',
					'id'                 => '',
					'class'              => 'city select2',
					'depth'              => 1,
					'tab_index'          => 0,
				    'orderby'            => 'name',
				    'order'              => 'ASC',
					'taxonomy'           => $taxonomy_location_url );
				wp_dropdown_categories( $args );
			} else {
				echo $city_text;
			}
		} else { ?>
			<input type="text" name="city" id="city" class="input longinput" value="<?php echo $city; ?>" />
		<?php } ?>
	</div> <!-- city --> <div class="formseparator"></div>

	<div class="form-label">
	    <label for="aboutagency"><?php _de('About the %s',520,ucfirst($taxonomy_agency_name)); ?><i>*</i></label>
	</div>
	<div class="form-input">
	    <textarea name="aboutagency" id="aboutagency" class="textarea longtextarea" rows="7"><?php echo $aboutagency; ?></textarea>
	</div> <!-- about agency --> <div class="formseparator"></div>

    <?php if(get_option('recaptcha_sitekey') && get_option('recaptcha_secretkey') && !is_user_logged_in() && get_option("recaptcha3")) { ?>
	<div class="form-input">
		<div class="g-recaptcha" data-sitekey="<?php echo get_option('recaptcha_sitekey'); ?>"></div>
	</div> <!-- captcha --> <div class="formseparator"></div>
    <?php } ?>

    <div class="center"><input type="submit" name="submit" value="<?php if($agency_post_id) { _de('Update Profile',450); } else { _de('Complete Registration',452); } ?>" class="bluebutton rad3" /></div> <!--center-->
</form>