<?php
/*
Template Name: Classified Ads - All
*/

get_header(); ?>

	<div class="contentwrapper">
	<div class="body">
    	<div class="bodybox">
        	<h3 class="l"><?php _de('Classified ads',374); ?></h3>
            <a href="<?php echo get_permalink(get_option('see_all_ads_page_id')); ?>" class="bluebutton rad3 r"><?php _de('All',375); ?></a>
            <span class="r">&nbsp;</span>
            <a href="<?php echo get_permalink(get_option('see_looking_ads_page_id')); ?>" class="bluebutton rad3 r"><?php _de('Looking',376); ?></a>
            <span class="r">&nbsp;</span>
            <a href="<?php echo get_permalink(get_option('see_offering_ads_page_id')); ?>" class="bluebutton rad3 r"><?php _de('Offering',377); ?></a>
            <div class="clear10"></div>
			<?php
			$posts_per_page = "40";
			$args = array(
				'post_type' => 'ad',
				'posts_per_page' => $posts_per_page,
				'paged' => $paged
				);
			query_posts($args);
			if ( have_posts() ) : ?>
			<table class="listagencies">
				<tr class="trhead rad5">
					<th><?php _de('Title',319); ?></th>
			        <th><?php _de('Type',320); ?></th>
			        <th><?php _de('Date added',321); ?></th>
				</tr>
			<?php
			$i = 1;
			while ( have_posts() ) : the_post();
				if (get_post_meta(get_the_ID(),'type', true) == "offering") {
					$classifiedadtype = _d('offering',326);
				}
				if (get_post_meta(get_the_ID(),'type', true) == "looking") {
					$classifiedadtype = _d('looking',327);
				}
				if ($i % 2) {
					$trclass = " whiterow";
				}
			?>
				<tr class="agencytr<?php echo $trclass ?>">
			    	<td><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></td>
			        <td><?php echo $classifiedadtype; ?></td>
			        <td><?php the_time("d F Y"); ?></td>
			    </tr>
			<?php unset($trclass); $i++; endwhile; ?>
			</table>
			<?php
				$total = ceil($wp_query->found_posts / $posts_per_page);
				dolce_pagination($total, $paged);
			else:
				_de('No classified ads yet',322);
			endif;
			wp_reset_query();
			?>
            <div class="clear"></div>
        </div> <!-- BODY BOX -->
    </div> <!-- BODY -->
    </div> <!-- contentwrapper -->

	<?php get_sidebar("left"); ?>
	<?php get_sidebar("right"); ?>
	<div class="clear"></div>

<?php get_footer(); ?>