<?php
global $taxonomy_location_url, $taxonomy_profile_name_plural;
get_header();
?>

		<div class="contentwrapper">
		<div class="body">
        	<div class="bodybox">
<?php
		$from = get_term($wp_query->queried_object_id, $taxonomy_location_url);
		$from = $from->name;

$posts_per_page = "40";
$term = get_term($wp_query->queried_object_id, $taxonomy_location_url);
if($_GET['page']) { $paged = (int)$_GET['page']; }
if($wp_query->query_vars['page']) { $paged = $wp_query->query_vars['page']; }

$premium_all_args = array(
	'post_type' => $taxonomy_profile_url, 'posts_per_page' => "1", 'paged' => "1",
	'meta_query' => array( array( 'key' => 'premium', 'value' => '1', 'compare' => '=', 'type' => 'NUMERIC' ) ),
	'tax_query' => array( array( 'taxonomy' => $taxonomy_location_url, 'field' => 'id', 'terms' => $term->term_id ) )
);
$premium_all = new WP_Query( $premium_all_args ); $premium_found_posts = $premium_all->found_posts;

$normal_all_args = array(
	'post_type' => $taxonomy_profile_url, 'posts_per_page' => "1", 'paged' => "1",
	'meta_query' => array( array( 'key' => 'premium', 'value' => '0', 'compare' => '=', 'type' => 'NUMERIC' ) ),
	'tax_query' => array( array( 'taxonomy' => $taxonomy_location_url, 'field' => 'id', 'terms' => $term->term_id ) )
);
$normal_all = new WP_Query( $normal_all_args ); $normal_found_posts = $normal_all->found_posts;

$premium_args = array(
	'post_type' => $taxonomy_profile_url,
	'posts_per_page' => $posts_per_page,
	'orderby' => 'meta_value_num', 'meta_key' => 'premium_since',
	'paged' => $paged,
	'meta_query' => array( array( 'key' => 'premium', 'value' => '1', 'compare' => '=', 'type' => 'NUMERIC' ) ),
	'tax_query' => array( array( 'taxonomy' => $taxonomy_location_url, 'field' => 'id', 'terms' => $term->term_id ) )
);
$premium = new WP_Query( $premium_args );

if($paged < "2") {
	$normal_offset = "0";
} else {
	$normal_offset = ($paged-1)*$posts_per_page - $premium_found_posts;
	if($normal_offset < 0) { $normal_offset = "0"; }
}
$normal_args = array(
	'offset' => $normal_offset,
	'post_type' => $taxonomy_profile_url,
	'posts_per_page' => $posts_per_page - count($premium->posts),
	'orderby' => 'date',
	'order' => 'DESC',
	'meta_query' => array( array( 'key' => 'premium', 'value' => '0', 'compare' => '=', 'type' => 'NUMERIC' ) ),
	'tax_query' => array( array( 'taxonomy' => $taxonomy_location_url, 'field' => 'id', 'terms' => $term->term_id ) )
);

$all = $premium;
if(count($premium->posts) < $posts_per_page) {
	//only query the normal posts if we need to
	$normal = new WP_Query( $normal_args );

	$q = array_merge($premium->posts, $normal->posts);
	$all->post_count = count($q);
	$all->posts = $q;
}

$i = 1;
if ( $all->have_posts() ) : 
	echo '<h3>'.ucfirst($taxonomy_profile_name_plural)." "._d('from',314)." ".$from.'</h3>';
	echo '<div class="clear"></div>';

	while ( $all->have_posts() ) : $all->the_post();
		include (get_template_directory() . '/loop-show-profile.php');
	endwhile;

	$total = ceil(($premium_found_posts + $normal_found_posts) / $posts_per_page);
	// $format = get_option('permalink_structure') ? '?page=%#%' : '&page=%#%';
	// $base = get_term_link( $term );
	// dolce_pagination($total, $paged, $format, $base);
	// $total = ceil(($premium_found_posts + $normal_found_posts) / $posts_per_page);
	dolce_pagination($total, $paged);
endif;
wp_reset_query();
//SHOW NORMAL POSTS end




//if we don't find any escorts here then we search for some tours
if (($premium_found_posts + $normal_found_posts) == "0") {
	$args = array(
		'tax_query' => array( array( 'taxonomy' => $taxonomy_location_url, 'field' => 'id', 'terms' => $term->term_id ) ),
		'post_type' => 'tour',
		'meta_key' => 'start',
		'meta_query' => array(
			array(
				'key' => 'start',
				'value' => mktime(0, 0, 0, date("m"), date("d"), date("Y")),
				'compare' => '<=',
				'type' => 'NUMERIC'
			),
			array(
				'key' => 'end',
				'value' => mktime(23, 59, 59, date("m"), date("d"), date("Y")),
				'compare' => '>=',
				'type' => 'NUMERIC'
			)
		),
		'orderby' => 'meta_value_num',
		'order' => 'ASC',
		'paged' => $paged,
		'posts_per_page' => $posts_per_page
	);
	$tours = query_posts($args);

	$i = 1;
	if ( have_posts() ) :
		echo '<h3>'._d('Tours happening now in',110).' '.$from.'</h3>';

		while ( have_posts() ) : the_post();
			include (get_template_directory() . '/loop-show-tour.php');
		endwhile;

		$total = ceil(($wp_query->found_posts) / $posts_per_page);
		$format = get_option('permalink_structure') ? '?page=%#%' : '&page=%#%';
		$base = get_term_link( $term );
		dolce_pagination($total, $paged, $format, $base);
		echo '<div class="clear20"></div>';
	else:
		echo '<h3>'.ucfirst($taxonomy_profile_name_plural)." "._d('from',314)." ".$from.'</h3>';
		echo '<div class="clear"></div>';
		_de('No %s here yet',29,$taxonomy_profile_name_plural);
	endif;
	wp_reset_query();
}
?>
                <div class="clear"></div>
            </div> <!-- BODY BOX -->

            <div class="clear"></div>
        </div> <!-- BODY -->
		</div> <!-- contentwrapper -->

		<?php get_sidebar("left"); ?>
		<?php get_sidebar("right"); ?>
    	<div class="clear"></div>
<?php get_footer(); ?>